<?php
// Define the path to the log file
$log_file = '../log/markemail.log';

$entries = [];

if (file_exists($log_file)) {
    // Get the log entries
    $log_entries = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
    // Reverse the array and get the last 10 log entries
    $last_10_entries = array_slice(array_reverse($log_entries), 0, 10);
    
    // Iterate over each log entry
    foreach ($last_10_entries as $log_entry) {
        $log_parts = explode('|', $log_entry);
        // Extract relevant information
        $Email = trim($log_parts[0] ?? 'N/A');
        $Judul = trim($log_parts[1] ?? 'N/A');
        
        $entries[] = [
            'Email' => $Email,
            'Judul' => $Judul
        ];
    }
}

header('Content-Type: application/json');
echo json_encode($entries, JSON_PRETTY_PRINT);
?>
